/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.shedaniel.clothconfig2.forge.ClothConfigInitializer;
import me.shedaniel.clothconfig2.forge.api.PointHelper;
import me.shedaniel.clothconfig2.forge.api.ScrollingContainer;
import me.shedaniel.clothconfig2.forge.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicNewSmoothScrollingEntryListWidget<E extends DynamicEntryListWidget.Entry<E>>
extends DynamicEntryListWidget<E> {
    protected double target;
    protected boolean smoothScrolling = true;
    protected long start;
    protected long duration;

    public DynamicNewSmoothScrollingEntryListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.smoothScrolling = smoothScrolling;
    }

    @Override
    public void capYPosition(double double_1) {
        if (!this.smoothScrolling) {
            this.scroll = MathHelper.func_151237_a((double)double_1, (double)0.0, (double)this.getMaxScroll());
        } else {
            this.scroll = ScrollingContainer.clampExtension(double_1, this.getMaxScroll());
            this.target = ScrollingContainer.clampExtension(double_1, this.getMaxScroll());
        }
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.smoothScrolling) {
            return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.getListener() != null && this.func_231041_ay__() && button == 0 && this.getListener().func_231045_a_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.capYPosition(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = MathHelper.func_76125_a((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(MathHelper.func_151237_a((double)(this.getScroll() + deltaY * double_6), (double)0.0, (double)this.getMaxScroll()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        for (DynamicEntryListWidget.Entry entry : this.func_231039_at__()) {
            if (!entry.func_231043_a_(mouseX, mouseY, amount)) continue;
            return true;
        }
        if (!this.smoothScrolling) {
            this.scroll += 16.0 * -amount;
            this.scroll = MathHelper.func_151237_a((double)amount, (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        this.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
        return true;
    }

    public void offset(double value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public void scrollTo(double value, boolean animated, long duration) {
        this.target = ScrollingContainer.clampExtension(value, this.getMaxScroll());
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scroll = this.target;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        double[] target = new double[]{this.target};
        this.scroll = ScrollingContainer.handleScrollingPosition(target, this.scroll, this.getMaxScroll(), delta, this.start, this.duration);
        this.target = target[0];
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    @Override
    protected void renderScrollBar(MatrixStack matrices, Tessellator tessellator, BufferBuilder buffer, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (!this.smoothScrolling) {
            super.renderScrollBar(matrices, tessellator, buffer, maxScroll, scrollbarPositionMinX, scrollbarPositionMaxX);
        } else if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = MathHelper.func_76125_a((int)height, (int)32, (int)(this.bottom - this.top - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)this.getMaxScroll() ? (int)this.scroll - this.getMaxScroll() : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top, this.top), this.bottom - height);
            int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 168 : 128;
            int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 222 : 172;
            Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)this.bottom, 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)this.bottom, 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)this.top, 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)this.top, 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)(minY + height), 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)(minY + height), 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)minY, 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)minY, 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)(minY + height - 1), 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)(scrollbarPositionMaxX - 1), (float)(minY + height - 1), 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)(scrollbarPositionMaxX - 1), (float)minY, 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)minY, 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    public static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;
        public static final double DOUBLE_EPSILON = 1.0E-7;

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }

        public static boolean almostEquals(double value1, double value2, double acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }

    public static class Interpolation {
        public static double expoEase(double start, double end, double amount) {
            return start + (end - start) * ClothConfigInitializer.getEasingMethod().apply(amount);
        }
    }
}

